package com.ejie.p06b.dokusi;

import java.io.StringReader;
import java.util.HashMap;


import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

//adriimport util.r76bCParametros;
import com.ejie.p06b.util.P06BParametros;

import com.bea.xml.XmlException;
import com.bea.xml.XmlOptions;
import com.ejie.t65.jaxb.beans.fsd.AttributeListDocument;
import com.ejie.t65.jaxb.beans.fsd.ConditionListDocument;
import com.ejie.t65.jaxb.beans.fsd.ContentDocument;
import com.ejie.t65.jaxb.beans.fsd.DocumentDocument;
import com.ejie.t65.jaxb.beans.fsd.DocumentIDDocument;
import com.ejie.t65.jaxb.beans.fsd.StringListDocument;
import com.ejie.t65.jaxb.beans.fsd.T65AttributeListType;
import com.ejie.t65.jaxb.beans.fsd.T65ConditionListType;
import com.ejie.t65.jaxb.beans.fsd.T65ContentType;
import com.ejie.t65.jaxb.beans.fsd.T65DocumentIDType;
import com.ejie.t65.jaxb.beans.fsd.T65DocumentType;
import com.ejie.t65.jaxb.beans.fsd.T65StringListType;

public class P06bDokusiXMLBeanParserConverter {


	// Separador para metadatos multivalor
	public static final String SEP_METADAT_MULTIVALOR = "#";

	private P06bDokusiXMLBeanParserConverter() {
	}

	public static String parseToStringDocumentID(String oid) {
		DocumentIDDocument docDocumentID = DocumentIDDocument.Factory
				.newInstance();
		T65DocumentIDType tipoDocumentID = T65DocumentIDType.Factory
				.newInstance();
		tipoDocumentID.setId(oid);
		docDocumentID.setDocumentID(tipoDocumentID);
		String xmlDocumentID = docDocumentID.xmlText();
		// p43bClsLog.debug("xmlDocumentID: "+xmlDocumentID);
		return xmlDocumentID;
	}

	private static XmlOptions createXMLOptions() {
		XmlOptions xmlOptions = new XmlOptions();
		xmlOptions.setSavePrettyPrint();
		xmlOptions.setSavePrettyPrintIndent(4);
		return xmlOptions;
	}

	public static String parseToStringContent(T65ContentType content) {
		ContentDocument docContent = ContentDocument.Factory.newInstance();
		docContent.setContent(content);
		String xmlContent = docContent
				.xmlText(P06bDokusiXMLBeanParserConverter.createXMLOptions());
		// p43bClsLog.debug("xmlContent: "+xmlContent);
		return xmlContent;
	}

	public static String parseToStringStringList(T65StringListType listaCadenas) {
		StringListDocument docStringList = StringListDocument.Factory
				.newInstance();
		docStringList.setStringList(listaCadenas);
		String xmlStringList = docStringList
				.xmlText(P06bDokusiXMLBeanParserConverter.createXMLOptions());
		// p43bClsLog.debug("xmlStringList: "+xmlStringList);
		return xmlStringList;
	}

	public static T65DocumentType parseToT65BDocument(String strXMLBean) {
		try {
			HashMap<String, String> map = new HashMap<String, String>();
			map.put("", P06BParametros.get("namespaceDokusi"));

			XmlOptions xmlOptions = new XmlOptions();
			xmlOptions.setLoadSubstituteNamespaces(map);

			DocumentDocument docDocument = DocumentDocument.Factory.parse(
					strXMLBean, xmlOptions);

			T65DocumentType retorno = docDocument.getDocument();
			return retorno;
		} catch (XmlException e) {
			// p43wClsLog.error("Excepcion en parseToT65BDocument", e);
			return null;
		}
	}

	public static String parseToStringCondition(
			T65ConditionListType listaCadenas) {
		ConditionListDocument docConditionList = ConditionListDocument.Factory
				.newInstance();
		docConditionList.setConditionList(listaCadenas);
		String xmlStringList = docConditionList
				.xmlText(P06bDokusiXMLBeanParserConverter.createXMLOptions());
		// p43bClsLog.debug("xmlStringList: "+xmlStringList);
		return xmlStringList;
	}

	public static String parseToStringAttribute(
			T65AttributeListType listaCadenas) {
		AttributeListDocument docAttributeList = AttributeListDocument.Factory
				.newInstance();
		docAttributeList.setAttributeList(listaCadenas);
		String xmlStringList = docAttributeList
				.xmlText(P06bDokusiXMLBeanParserConverter.createXMLOptions());
		// p43bClsLog.debug("xmlStringList: "+xmlStringList);
		return xmlStringList;
	}

	public static String getDocumentOids(String strXMLBean) {

		try {

			StringBuffer oids = new StringBuffer("");
			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document doc = builder.parse(new InputSource(new StringReader(
					strXMLBean)));
			NodeList listaNodos = doc.getElementsByTagName("object");
			for (int index = 0; index < listaNodos.getLength(); index++) {
				Node fstNode = listaNodos.item(index);
				if (fstNode.getNodeType() == Node.ELEMENT_NODE) {
					if (fstNode.hasAttributes()) {
						oids.append(","
								+ fstNode.getAttributes().item(0)
										.getNodeValue());
					}
				}
			}

			return oids.toString().replaceFirst(",", "");
		} catch (Exception e) {
			return null;
		}
	}
}
